'use strict';

function GroupRemoveModalCtrl($scope, $rootScope, $http, AppConfig, GroupsManager, GroupsRoundsManager, GroupResults){

    $scope.$on('Groups:openRemoveGroupModal', function(event, group){
        $scope.openModal();
        $scope.group = group;
    });


    $scope.openModal = function(){
        angular.element('#modal-group-remove').modal('show');
    }

    $scope.closeModal = function(){
        angular.element('#modal-group-remove').modal('hide');
    }


    $scope.removeGroup = function(){
        var message = {
            title: 'Usuwanie grupy'
            ,msg: 'Trwa usuwanie grupy'
        }
        var messageError = {
            title: 'Błąd'
            ,msg: ''
        }

        $scope.closeModal();

        $rootScope.$broadcast('Message:addMsg', message);

        $http.get(AppConfig.urlGroupRemove + '/' + $scope.group.id)
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                $scope.closeModal();
                if(typeof data.error != 'undefined')
                {
                    $rootScope.$broadcast('Message:error', data.error);
                }
                else
                {
                    GroupsManager.removeGroup($scope.group);
                }
                GroupsRoundsManager.clearAll();
                GroupResults._isLoadedData = false;
            })
            .error(function(data){

            })
        ;
    }
}

GroupRemoveModalCtrl.$inject = ['$scope', '$rootScope', '$http', 'AppConfig', 'GroupsManager', 'GroupsRoundsManager', 'GroupResults'];